package com.agilex.healthcare.veteranappointment.utils.linkbuilder;


import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.veteranappointment.domain.VARPatientPreference;

import javax.ws.rs.core.UriBuilder;
import java.net.URI;

public class PatientPreferencesLinkBuilder {
	private URI baseUri;

	public PatientPreferencesLinkBuilder(URI baseUri) {
		UriDtoValidator.validate(baseUri);
		this.baseUri = baseUri;
	}

	public VARPatientPreference fillLinks(VARPatientPreference pref, URI requestUri) {
		if(pref !=null) {
			UriHelper.setSelfUri(pref, requestUri, getCannonicalSelfUri(pref));
		}
		return pref;
	}

	protected URI getBaseUri() {
		return this.baseUri;
	}
	
//	protected URI extractPatientUri(PatientPreference pref) {
//		return PatientUriHelper.createPatientSelfUri(pref.getPatientIdentifier(), baseUri);
//	}

	protected URI getCannonicalSelfUri(VARPatientPreference perf) {
		return UriBuilder.fromUri(createPatientSelfUri(perf.getPatientIdentifier(), baseUri)).path("preference").build();
	}

    public URI createPatientSelfUri(PatientIdentifier patientIdentifier, URI baseUri) {
        URI uri = null;
        if (patientIdentifier != null) {
            uri = null;
            if (NullChecker.isNotNullish(patientIdentifier.getUniqueId()) && NullChecker.isNotNullish(patientIdentifier.getAssigningAuthority())) {
                uri = UriBuilder.fromPath(baseUri.getPath()).path("patient").path(patientIdentifier.getAssigningAuthority()).path(patientIdentifier.getUniqueId()).build();
            }
        }
        return uri;
    }
	
}
